; Script file for HyperTerminal version 690170
;Copyright 1998, 1999 Henter-Joyce, Inc.
; 9/28/97. A.G.
;Modified and updated 3/30/99 by DB

include "hjconst.jsh"
include "hjglobal.jsh"
include "hypertrm.jsm"
Globals
	int HasRunBefore, ; for AutoStartEvent
	int LocalScreenEcho ; used in SayNonHighlightedText to decide if the new written text must be spoken. 
		; Set to true or false by ToggleMonitoring.

Function AutoStartEvent ()
if not HasRunBefore then
	let HasRunBefore = true
	Say (msg1, OT_HELP) ; "To toggle monitoring mode on and off, use "
	Say (GetScriptKeyName ("ToggleMonitoring"), OT_HELP)
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("HyperTerminal")
EndScript

Script ScreenSensitiveHelp ()
;wc1 = "term class"
if (GetWindowClass (GetCurrentWindow ()) == wc1) then
	Say (msg2, OT_HELP) ; "this is the main terminal window "
	Say (msg3, OT_HELP) ; "in which the data being transmited is displayed"
else
	PerformScript ScreenSensitiveHelp ()
EndIf
EndScript

Script HotKeyHelp ()
Say (msg1, OT_HELP) ; "To toggle monitoring mode on and off, use "
Say (GetScriptKeyName ("ToggleMonitoring"), OT_HELP)
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Function SayFocusedWindow ()
;wc1 = "term class"
if (GetWindowClass (GlobalFocusWindow) == wc1) then
	Say (GetWindowName (GetRealWindow (GlobalFocusWindow)), OT_WINDOW_NAME)
	return
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if (LocalScreenEcho == 1) then
	if ((GetFocus () == hwnd) 
		;wc1 = "term class"
		&& ((TheClass == wc1)
		;wc2 = "edit"
		|| (TheClass == wc2))) then
		Say (buffer, OT_BUFFER)
		return
	EndIf
EndIf
if ((GetScreenEcho() > 1)
	;wc3 = "#32771"
	|| (TheClass == wc3)) then
	Say (buffer, OT_BUFFER)
EndIf
EndFunction

Script ToggleMonitoring ()
if LocalScreenEcho then
	let LocalScreenEcho = 0
	Say (msg4, OT_MESSAGE) ; "Monitoring off"
else
	let LocalScreenEcho = 1
	Say (msg5, OT_MESSAGE) ; "Monitoring on"
EndIf
EndScript
